/****************************************************************************/
/* FILE NAME: DSPI_test.c                       COPYRIGHT (c) Freescale 2006*/
/*                                                All Rights Reserved     	*/
/* DESCRIPTION:                                                           	*/
/* This performs DSPI communication and sets LEDs when complete.			*/
/*========================================================================	*/
/* REV      AUTHOR        DATE        DESCRIPTION OF CHANGE               	*/
/* ---   -----------    ----------    ---------------------               	*/
/* 0.1	  D.Paterson	01/Feb/07    Initial Version					  	*/
/****************************************************************************/
#include "mpc5561.h"
#include "typedefs.h"

#define DSPIB_PUSHR  0xFFF94034
#define DSPIC_PUSHR  0xFFF98034

#define DSPIB_POPR   0xFFF94038
#define DSPIC_POPR   0xFFF98038

#define DSPIA_RXFR   0xFFF9007C

int DSPIB_complete;
int DSPIC_complete;

extern vuint32_t DSPI_RXQUEUE[2];   // Set up a result queue for DSPI B  
extern vuint32_t DSPI_RXQUEUE1[2];  // Set up a result queue for DSPI C  

void DSPI_test(void);
void initDMA(void);
void initDSPI(void);


/**************************************************************************/
/* FUNCTION     : DSPI_test		  										  */
/* PURPOSE      : Initializes RXQUEUES and waits for eDMA to complete	  */
/**************************************************************************/
void DSPI_test(void)
{	

    DSPI_RXQUEUE[0] = 0x0;   		// Initialise RXQUEUE for DSPIB to all 0's
    DSPI_RXQUEUE[1] = 0x0;
    
    DSPI_RXQUEUE1[0] = 0x0;   	// Initialise RXQUEUE for DSPIc to all 0's
    DSPI_RXQUEUE1[1] = 0x0;
    
    while (EDMA.IRQRL.B.INT13 ==0) {} /*wait for the DMA to be done */
    DSPIB_complete = 1;
    while (EDMA.IRQRL.B.INT15 ==0) {} /*wait for the DMA to be done */	
    DSPIC_complete = 1;

	//Set LED if passed
	if (DSPIB_complete == 1)
	{SIU.GPDO[206].R = 1;}

	if (DSPIC_complete == 1)
	{SIU.GPDO[207].R = 1;}
	
	//Clear the interrupts
	EDMA.IRQRL.B.INT13 = 1;
	EDMA.IRQRL.B.INT15 = 1;
}

/**************************************************************************/
/* FUNCTION     : initDSPI		  										  */
/* PURPOSE      : Initializes DSPI B & C modules as slaves				  */
/**************************************************************************/
void initDSPI(void) 
 { 
  //	SDPI B & C using external connections 

  DSPI_B.MCR.R		= 0x00010000;	/* SPI mode DSPIB = Slave SS0=active lo*/
  DSPI_B.CTAR[0].R 	= 0x78003255;
  
  DSPI_C.MCR.R		= 0x00010000;	/* SPI mode DSPIC = Slave SS0=active lo*/
  DSPI_C.CTAR[0].R 	= 0x78003255;

  SIU.DISR.R 		= 0x00000000;	/* EXTERNAL CONNECTIONS REQ'D*/
  DSPI_C.RSER.R		= 0x00030000;	/* Setup RFDF to cause DMA transfer */	
  DSPI_B.RSER.R		= 0x00030000;	/* Setup RFDF to cause DMA transfer */ 
  }

/**************************************************************************/
/* FUNCTION     : initDMA		  										  */
/* PURPOSE      : Initializes eDMA for moving RX Data    				  */
/**************************************************************************/
void initDMA(void)
{
     		// DMA Configuration Register (DMACR)                     
     		EDMA.CR.R   = 0x00000400;  // Channel group 1 priority. Group 1 priority level when fixed priority group arbitration is enabled. 
     		
     		// DMA Enable Request Registers (DMAERQL)                     
     		EDMA.ERQRL.R   = 0x0000A000; //0x00009000;  // DMA Enable Request Register Low (Channels 31-0) :  Ch14=DSPIC TXFFF,Ch15 DSPIC RFDF,Ch16 DSPIC TFFF, Ch17=DSPID RFDF 
     		
     		// DMA Enable Error Interrupt Request Registers (DMAEEIH,DMAEEIL)                     
     		EDMA.EEIRL.R   = 0x00000000;  // DMA Error Interrupt Enable Register Low (Channels 0-31) : 
     		
     		// DMA Channel Priority Register Settings (DCHPRIn) Channels 0 - 63                     
     		EDMA.CPR[0].R = 0x00;    // Channel 0 is Priority 1, Channel Preemption is Disabled
     		EDMA.CPR[1].R = 0x01;    // Channel 1 is Priority 2, Channel Preemption is Disabled
     		EDMA.CPR[2].R = 0x02;    // Channel 2 is Priority 3, Channel Preemption is Disabled
     		EDMA.CPR[3].R = 0x03;    // Channel 3 is Priority 4, Channel Preemption is Disabled
     		EDMA.CPR[4].R = 0x04;    // Channel 4 is Priority 5, Channel Preemption is Disabled
     		EDMA.CPR[5].R = 0x05;    // Channel 5 is Priority 6, Channel Preemption is Disabled
     		EDMA.CPR[6].R = 0x06;    // Channel 6 is Priority 7, Channel Preemption is Disabled
     		EDMA.CPR[7].R = 0x07;    // Channel 7 is Priority 8, Channel Preemption is Disabled
     		EDMA.CPR[8].R = 0x08;    // Channel 8 is Priority 9, Channel Preemption is Disabled
     		EDMA.CPR[9].R = 0x09;    // Channel 9 is Priority 10, Channel Preemption is Disabled
     		EDMA.CPR[10].R = 0x0A;    // Channel 10 is Priority 11, Channel Preemption is Disabled
     		EDMA.CPR[11].R = 0x0B;    // Channel 11 is Priority 12, Channel Preemption is Disabled
     		EDMA.CPR[12].R = 0x0C;    // Channel 12 is Priority 13, Channel Preemption is Disabled
     		EDMA.CPR[13].R = 0x0D;    // Channel 13 is Priority 14, Channel Preemption is Disabled
     		EDMA.CPR[14].R = 0x0E;    // Channel 14 is Priority 15, Channel Preemption is Disabled
     		EDMA.CPR[15].R = 0x0F;    // Channel 15 is Priority 16, Channel Preemption is Disabled
     		EDMA.CPR[16].R = 0x00;    // Channel 16 is Priority 1, Channel Preemption is Disabled
     		EDMA.CPR[17].R = 0x01;    // Channel 17 is Priority 2, Channel Preemption is Disabled
     		EDMA.CPR[18].R = 0x02;    // Channel 18 is Priority 3, Channel Preemption is Disabled
     		EDMA.CPR[19].R = 0x03;    // Channel 19 is Priority 4, Channel Preemption is Disabled
     		EDMA.CPR[20].R = 0x04;    // Channel 20 is Priority 5, Channel Preemption is Disabled
     		EDMA.CPR[21].R = 0x05;    // Channel 21 is Priority 6, Channel Preemption is Disabled
     		EDMA.CPR[22].R = 0x06;    // Channel 22 is Priority 7, Channel Preemption is Disabled
     		EDMA.CPR[23].R = 0x07;    // Channel 23 is Priority 8, Channel Preemption is Disabled
     		EDMA.CPR[24].R = 0x08;    // Channel 24 is Priority 9, Channel Preemption is Disabled
     		EDMA.CPR[25].R = 0x09;    // Channel 25 is Priority 10, Channel Preemption is Disabled
     		EDMA.CPR[26].R = 0x0A;    // Channel 26 is Priority 11, Channel Preemption is Disabled
     		EDMA.CPR[27].R = 0x0B;    // Channel 27 is Priority 12, Channel Preemption is Disabled
     		EDMA.CPR[28].R = 0x0C;    // Channel 28 is Priority 13, Channel Preemption is Disabled
     		EDMA.CPR[29].R = 0x0D;    // Channel 29 is Priority 13, Channel Preemption is Disabled
     		EDMA.CPR[30].R = 0x0E;    // Channel 30 is Priority 15, Channel Preemption is Disabled
     		EDMA.CPR[31].R = 0x0F;    // Channel 31 is Priority 16, Channel Preemption is Disabled

            // Transfer Control Descriptor for DSPI B RFDF 
            EDMA.TCD[13].SADDR = DSPIB_POPR;          		//  Start Address 
            EDMA.TCD[13].DADDR = (vuint32_t) &DSPI_RXQUEUE; //  Destination address 
            EDMA.TCD[13].SMOD = 0x00;                 		//  Source address modulo 
            EDMA.TCD[13].DMOD = 0x00;                 		//  Destination address modulo 
            EDMA.TCD[13].DSIZE = 0x02;                		//  Destination transfer size : 32 Bits 
            EDMA.TCD[13].SSIZE = 0x02;                		//  Source transfer size : 32 Bits 
            EDMA.TCD[13].SOFF = 0;                    		//  Signed source address offset 
			EDMA.TCD[13].NBYTES = 0x4;                		//  Inner "minor" byte count 
            EDMA.TCD[13].SLAST = 0;          	      		//  last Signed source address adjust                  
			EDMA.TCD[13].DOFF = 0x4;                  		//  Signed destination address offset 
            EDMA.TCD[13].DLAST_SGA = -0x8;            		//  Signed destination address adjust
            EDMA.TCD[13].BITERE_LINK = 0x0;           		
            EDMA.TCD[13].BITER = 0x2;                 		//  begining "major" iteration count 
            EDMA.TCD[13].CITERE_LINK = 0x0;           		              
            EDMA.TCD[13].CITER=0x2;                   		//  Current "major" iteration count Disabled
            EDMA.TCD[13].BWC = 0x00;                  		//  Bandwidth control :  No DMA Stalls 
            EDMA.TCD[13].MAJORLINKCH = 0x00;          		//  Major Channel number 
            EDMA.TCD[13].MAJORE_LINK = 0x0;           		//  Major Channel Link : Disabled
            EDMA.TCD[13].DONE = 0x00;                 		//  Channel Done 
            EDMA.TCD[13].ACTIVE = 0x00;               		//  Channel ACtive
            EDMA.TCD[13].E_SG = 0x0;                  		//  Enable Scatter/Gather : Disabled
            EDMA.TCD[13].D_REQ = 0x0;                 		//  Do NOT disable TCD When done   
            EDMA.TCD[13].INT_HALF = 0x0;              		//  Interrupt on minor loop count : Disabled
            EDMA.TCD[13].INT_MAJ = 0x1;               		//  Interrupt on major loop completion : Enabled
            EDMA.TCD[13].START = 0x00;                		//  Explicit Channel Start bit
            
            //  Transfer Control Descriptor for DSPI C RFDF 
            EDMA.TCD[15].SADDR = DSPIC_POPR;          		//  Start Address 
            EDMA.TCD[15].DADDR = (vuint32_t) &DSPI_RXQUEUE1;//  Destination address 
            EDMA.TCD[15].SMOD = 0x00;                 		//  Source address modulo 
            EDMA.TCD[15].DMOD = 0x00;                 		//  Destination address modulo 
            EDMA.TCD[15].DSIZE = 0x02;                		//  Destination transfer size : 32 Bits 
            EDMA.TCD[15].SSIZE = 0x02;                		//  Source transfer size : 32 Bits 
            EDMA.TCD[15].SOFF = 0;                    		//  Signed source address offset 
			EDMA.TCD[15].NBYTES = 0x4;         		  		//  Inner "minor" byte count 
            EDMA.TCD[15].SLAST = 0;          	      		//  last Signed source address adjust                  
			EDMA.TCD[15].DOFF = 0x4;                  		//  Signed destination address offset 
            EDMA.TCD[15].DLAST_SGA = -0x8;            		//  Signed destination address adjust
            EDMA.TCD[15].BITERE_LINK = 0x0;           		
            EDMA.TCD[15].BITER = 0x2;                 		//  begining "major" iteration count 
            EDMA.TCD[15].CITERE_LINK = 0x0;           		              
            EDMA.TCD[15].CITER=0x2; 				  		//  Current "major" iteration count Disabled
            EDMA.TCD[15].BWC = 0x00;                  		//  Bandwidth control :  No DMA Stalls 
            EDMA.TCD[15].MAJORLINKCH = 0x00;          		//  Major Channel number 
            EDMA.TCD[15].MAJORE_LINK = 0x0;           		//  Major Channel Link : Disabled
            EDMA.TCD[15].DONE = 0x00;                 		//  Channel Done 
            EDMA.TCD[15].ACTIVE = 0x00;               		//  Channel ACtive
            EDMA.TCD[15].E_SG = 0x0;                  		//  Enable Scatter/Gather : Disabled  
            EDMA.TCD[15].D_REQ = 0x0;                 		//  Do NOT disable TCD When done  
            EDMA.TCD[15].INT_HALF = 0x0;              		//  Interrupt on minor loop count : Disabled
            EDMA.TCD[15].INT_MAJ = 0x1;               		//  Interrupt on major loop completion : Enabled
            EDMA.TCD[15].START = 0x00;                		//  Explicit Channel Start bit
}